//////////////////////////////////////////
//                                      //
// Luminous Color Bleeding version 4    //
//        2007 Samuel T. Benge          //
//         distribute  freely           //
//                                      //
//////////////////////////////////////////

// remember to keep the output image size the same as the input image size
// render without aa

// beware of using png files which may have their own gamma values.....

// you can change the gamma, if needed
global_settings{assumed_gamma 1}

// global ambient value - do not change
#default{finish{ambient 1}}

// don't change the camera
camera{
 orthographic
 right x*2 up y*2
 location z*-1
 look_at 0 
}

// this file provides the points to be used for the bloom effect
// it is a circular array of 226 points
// a perfect array would use 256 points to max out the
// size limitation for pigment_maps
#include"circular.inc"


// edit the variables below
// **********************************************************************
// ***********************************

// it all starts here
#declare image_pigment=
pigment{
 image_map{
  
  // your image here
  // two dots before a forward slash moves the directory up one
  //png"../rocky.png"
  png"test_scene.png"
  
  // this helps enhance antialiasing of the original image
  interpolate 2
 }
  
  // these warp statements reduce unwanted edge artifacts
  warp{repeat x flip x}
  warp{repeat y flip y}
 
 // image orientation - do not change
 #declare image_scale = 2;
 scale image_scale translate (image_scale/2)*<-1,-1,0>
}

// intensity of original colors, increase to saturate image
// see bright, below
#declare intensity = 20;

// brightness of the effect
// to help balance the bloom effect, use the following guidelines:
// if: intensity = 5  then bright = 1
// if: intensity = 10 then bright = .5
// if: intensity = 20 then bright = .25
// if: intensity = 40 then bright = .125
#declare bright = .25;

// quality of the effect
// use values between 0 and 1 (with 1 being best [and slowest])
#declare quality = .5;

// radius of effect
// change independent values for width/height
#declare rad = <1,1>*.1;

// rotate the effect
// useful when using disproportionate radii
#declare rotation = 0;

// color threshold of effect
// use values between 0 and 1
// 0.0 - all colors bloomed somewhat
// 0.8 - only colors over a value of 0.8 will be bloomed
#declare place = .5;

// pw stands for poly_wave
// it moves the color threshold value (place) up or down, but with a curve
// 1 = no change, +1 = brighter spots are singled out
#declare pw = 1.25;

// ***********************************
// **********************************************************************
// end of variables


// the working code

// image as a function
#declare figm=
function{pigment{image_pigment}}

// image function is separated into its red, green, and blue
// components and recombined to preserve color saturation
#declare bloom_pigment=
pigment{
 average
 pigment_map{
  [1 function{figm(x,y,z).red} poly_wave pw color_map{[place rgb 1 transmit 1][1 rgb x*intensity]}]
  [1 function{figm(x,y,z).green} poly_wave pw color_map{[place rgb 1 transmit 1][1 rgb y*intensity]}]
  [1 function{figm(x,y,z).blue} poly_wave pw color_map{[place rgb 1 transmit 1][1 rgb z*intensity]}]
 }
}

// bloom effect is a result of the bloom_pigment moved and averaged 
#declare bloomed_luminescence=
plane{z,0
 pigment{
  average
  pigment_map{
   #declare V=0;
    #while(V<226)
     [2-vlength(pts[V])
      
      bloom_pigment
      
      rotate z*rotation
      translate<pts[V].x*rad.x,pts[V].y*rad.y,0>
      rotate -z*rotation
      
     ]
    #declare V=V+(1/quality);
   #end
  }
 }
 finish{ambient bright}
}

// underlying, unaffected image
#declare image=
plane{z,0
 pigment{
  image_pigment
 }
}
object{image translate z*.001}


// luminous-bloomed pigment
object{bloomed_luminescence}
